/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.commands;

import com.flemmli97.improvedmobs.capability.TileCapProvider;
import com.flemmli97.improvedmobs.config.EquipmentList;
import com.flemmli97.improvedmobs.difficulty.DifficultyData;
import com.flemmli97.improvedmobs.network.PacketHandler;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class IMCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"improvedmobs").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reloadJson").requires(src -> src.func_197034_c(2))).executes(IMCommand::reloadJson))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"difficulty").requires(src -> src.func_197034_c(2))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::setDifficulty)))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"val", (ArgumentType)FloatArgumentType.floatArg()).executes(IMCommand::addDifficulty)))));
    }

    private static int reloadJson(CommandContext<CommandSource> src) {
        ((CommandSource)src.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Reloading equipment.json"), true);
        try {
            EquipmentList.initEquip();
        }
        catch (EquipmentList.InvalidItemNameException e) {
            ((CommandSource)src.getSource()).func_197030_a((ITextComponent)new StringTextComponent(e.getMessage()), false);
        }
        return 1;
    }

    private static int setDifficulty(CommandContext<CommandSource> src) {
        DifficultyData data = DifficultyData.get((World)((CommandSource)src.getSource()).func_197023_e());
        data.setDifficulty(FloatArgumentType.getFloat(src, (String)"val"), ((CommandSource)src.getSource()).func_197028_i());
        ((CommandSource)src.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Difficulty set to " + data.getDifficulty()).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD)), true);
        return 1;
    }

    private static int addDifficulty(CommandContext<CommandSource> src) {
        DifficultyData data = DifficultyData.get((World)((CommandSource)src.getSource()).func_197023_e());
        data.addDifficulty(FloatArgumentType.getFloat(src, (String)"val"), ((CommandSource)src.getSource()).func_197028_i());
        ((CommandSource)src.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Difficulty set to " + data.getDifficulty()).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD)), true);
        return 1;
    }

    private static int setDifficultyPlayer(CommandContext<CommandSource> src) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.func_197109_a(src, (String)"players");
        MinecraftServer server = ((CommandSource)src.getSource()).func_197028_i();
        for (GameProfile prof : profs) {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(prof.getId());
            TileCapProvider.getPlayerDifficultyData(player).ifPresent(data -> {
                data.setDifficultyLevel(FloatArgumentType.getFloat((CommandContext)src, (String)"val"));
                PacketHandler.sendDifficultyToClient(DifficultyData.get(player.field_70170_p), player);
                ((CommandSource)src.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel()).func_230530_a_(Style.field_240709_b_.func_240720_a_(new TextFormatting[]{TextFormatting.GOLD})), true);
            });
        }
        return profs.size();
    }

    private static int addDifficultyPlayer(CommandContext<CommandSource> src) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.func_197109_a(src, (String)"players");
        MinecraftServer server = ((CommandSource)src.getSource()).func_197028_i();
        for (GameProfile prof : profs) {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(prof.getId());
            TileCapProvider.getPlayerDifficultyData(player).ifPresent(data -> {
                data.setDifficultyLevel(data.getDifficultyLevel() + FloatArgumentType.getFloat((CommandContext)src, (String)"val"));
                PacketHandler.sendDifficultyToClient(DifficultyData.get(player.field_70170_p), player);
                ((CommandSource)src.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Difficulty for " + prof.getName() + " set to " + data.getDifficultyLevel()).func_230530_a_(Style.field_240709_b_.func_240720_a_(new TextFormatting[]{TextFormatting.GOLD})), true);
            });
        }
        return profs.size();
    }
}

